package com.hero.objects.powers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Intelligence;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Detect extends Sense {

	private static String xmlID = "DETECT";

	public Detect(Element root) {
		super(root, Detect.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		String whatString = getSelectedOption().getAlias();
		boolean swap = false;
		ArrayList<Adder> assigned = getAssignedAdders();
		for (Adder ad : assigned) {
			if (ad.getXMLID().equals("EXTRA")) {
				whatString += ", " + ad.getAlias();
				swap = true;
				ad.setDisplayInString(false);
			}
		}
		if (swap) {
			whatString = whatString.substring(0, whatString.lastIndexOf(","))
					+ " and"
					+ whatString.substring(whatString.lastIndexOf(",") + 1,
							whatString.length());
		}
		ret += " " + whatString;
		ret += " " + getDamageDisplay();

		if ((getGroup() != null) && (getAvailableGroups().size() > 1)) {
			ret += " (" + getGroup().getAlias() + ")";
		} else if ((getGroup() == null) && (getAvailableGroups().size() > 1)) {
			ret += " (Unusual Group)";
		}
		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += ", " + adderString;
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}

		return ret;
	}

	protected boolean isFocus() {
		if (GenericObject.findObjectByID(getAssignedModifiers(), "FOCUS") != null) {
			return true;
		}
		if (getParentList() != null) {
			if (GenericObject.findObjectByID(getParentList()
					.getAssignedModifiers(), "FOCUS") != null) {
				return true;
			}
		}
		return false;
	}

	@Override
	public String getDamageDisplay() {
		int base1 = 0;
		int base2 = 0;
		String ret = "";
		if (isFocus() && HeroDesigner.getActiveHero() != null) {
			int roll = HeroDesigner.getActiveHero().getRules()
					.getSkillRollBase();
			if (getLevels() < 0) {
				roll = getMinimumLevel();
			} else {
				roll = roll + getLevels();
			}
			ret = "" + (9 + getLevels()) + "-";
		} else {

			Intelligence intel = (Intelligence) HeroDesigner.getActiveHero()
					.getCharacteristic(Constants.INT);
			if (intel == null) {
				intel = new Intelligence(new Element("INT"));
				intel.setLevels((int) Rounder.roundHalfDown(HeroDesigner
						.getActiveTemplate().getGeneralLevel()
						- intel.getBaseValue()));
			}
			base1 = intel.getPrimaryPERRoll() + getLevels();
			base2 = intel.getSecondaryPERRoll() + getLevels();
			ret = "" + base1 + "-";
			if (base1 != base2) {
				ret += "/" + base2 + "-";
			}
		}
		return ret;
	}

	@Override
	public Element getSaveXML() {
		Element ret = super.getSaveXML();
		ret.setAttribute("ACTIVE", active ? "Yes" : "No");
		return ret;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "ACTIVE");
		active = (check != null) && check.trim().toUpperCase().startsWith("Y");
	}
}